import {ParsedQuery} from 'query-string';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';
import {ERedirectStatusCodes} from 'constants/redirectStatusCodes';

import {internalUrl} from 'utilities/url';

export interface IRedirectOptions {
    path: string;
    statusCode: ERedirectStatusCodes;
}

const START_DATE_FIELD_NAME = 'startDate';

export const getAviaRedirectOptionsByQuery = (
    query: ParsedQuery,
): IRedirectOptions | null => {
    if (__SERVER__) {
        const {when} = query;

        if (!when) {
            return {
                path: internalUrl(URLs[EProjectName.AVIA], {
                    ...query,
                    focus: START_DATE_FIELD_NAME,
                }),
                statusCode: ERedirectStatusCodes.TEMPORARILY,
            };
        }
    }

    return null;
};
