/**
 * Функция возвращает ключ для списка групп авиа сегментов.
 * Возвращаем рандомный ключ, чтобы React не смог сопоставить элементы в списке и отрендерил элементы заново,
 * чтобы отобразить скелетон, т.к. это быстрей и рендер контента произойдет асинхронно.
 */
export default function getAviaSliceKey(
    prevIsLoading: boolean,
    permanentKey: string,
): string {
    if (prevIsLoading) {
        return permanentKey;
    }

    return String(Math.random());
}
