import {EPriceHintType} from 'projects/avia/components/Dynamics/utilities/getPriceHintType';

import {
    dynamicsDashTitleDashExpensive,
    dynamicsDashTitleDashMinimal,
    dynamicsDashTitleDashNormal,
} from 'i18n/avia-AviaDynamics';

export default function getDynamicTitle(priceType: EPriceHintType): string {
    switch (priceType) {
        case EPriceHintType.ACCEPTABLE:
            return dynamicsDashTitleDashNormal();
        case EPriceHintType.EMPTY:
            return dynamicsDashTitleDashNormal();
        case EPriceHintType.EXPENSIVE:
            return dynamicsDashTitleDashExpensive();
        case EPriceHintType.MINIMAL:
            return dynamicsDashTitleDashMinimal();
    }
}
