import {useMemo} from 'react';

import {IAnywhereSettlementInfo} from 'types/avia/landing/ISettlementInfo';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Heading from 'components/Heading/Heading';
import Carousel from 'components/Carousel/Carousel';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';
import Flex from 'components/Flex/Flex';

import {SearchToAnywhereSettlement} from '../SearchToAnywhereSettlement/SearchToAnywhereSettlement';

import cx from './SearchAnywhereSettlementGroup.scss';

interface ISearchAnywhereSettlementGroupParams {
    header: string | null;
    settlements: IAnywhereSettlementInfo[];
    onSettlementClick: (settlement: IAnywhereSettlementInfo) => void;
    isCarousel: boolean;
    headerClass: string;
    containerClass: string;
}

export const SearchAnywhereSettlementGroup: React.FC<ISearchAnywhereSettlementGroupParams> =
    ({
        header,
        settlements,
        onSettlementClick,
        isCarousel,
        headerClass,
        containerClass,
    }) => {
        const {isDesktop} = useDeviceType();

        const content = useMemo(() => {
            const settlementsNodes = settlements.map(settlement => (
                <SearchToAnywhereSettlement
                    key={settlement.key}
                    settlement={settlement}
                    onClick={onSettlementClick}
                />
            ));

            if (isCarousel) {
                if (isDesktop) {
                    return (
                        <Carousel
                            spaceBetween={5}
                            className={containerClass}
                            buttonClassName={cx('carouselButton')}
                        >
                            {settlementsNodes}
                        </Carousel>
                    );
                }

                return (
                    <HorizontalScroller>
                        <Flex between={2} inline nowrap>
                            {settlementsNodes}
                        </Flex>
                    </HorizontalScroller>
                );
            }

            return <div className={containerClass}>{settlementsNodes}</div>;
        }, [
            containerClass,
            isCarousel,
            isDesktop,
            onSettlementClick,
            settlements,
        ]);

        return (
            <>
                {header && (
                    <Heading level={1} className={headerClass}>
                        {header}
                    </Heading>
                )}
                {content}
            </>
        );
    };
