import {useCallback} from 'react';

import {IAnywhereSettlementInfo} from 'types/avia/landing/ISettlementInfo';

import {searchToAnywhereInlineSearchDataForCitySelector} from 'selectors/avia/searchToAnywhere/searchToAnywhereSelectors';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {russiaCountryId} from '../../utilities/countryRegionMap';

import Settlement from 'projects/avia/components/Settlement/Settlement';

import cx from './SearchToAnywhereSettlement.scss';

interface ISearchToAnywhereSettlementParams {
    settlement: IAnywhereSettlementInfo;
    onClick: (settlement: IAnywhereSettlementInfo) => void;
}

export const SearchToAnywhereSettlement: React.FC<ISearchToAnywhereSettlementParams> =
    ({settlement, onClick}) => {
        const {isDesktop} = useDeviceType();

        const onClickHandler = useCallback(() => {
            onClick(settlement);
        }, [onClick, settlement]);

        const point =
            settlement.country_restrictions.metrics.entranceForRussians
                ?.point_info;

        const country = point?.title.nominative_case;
        const countryId = point?.geo_id;
        const isCountryRussia = countryId === russiaCountryId;

        return (
            <Settlement
                className={cx('settlement')}
                cityKey={settlement.key}
                title={settlement.title.nominativeCase}
                description={isCountryRussia ? undefined : country}
                images={settlement.images}
                minWidth={isDesktop ? 285 : 190}
                size={isDesktop ? 'm' : 's'}
                price={settlement.price}
                inlineSearchDataForCitySelector={
                    searchToAnywhereInlineSearchDataForCitySelector
                }
                onClick={onClickHandler}
            />
        );
    };
