import {IAviaSearchToAnywhereFilters} from '../types/IAviaSearchToAnywhereFilters';

import {
    countryFilterToText,
    covid19FilterToText,
} from '../utilities/filterToTextMap';

import * as i18nBlock from 'i18n/avia-SearchToAnywhere';

export const useAviaSearchToAnywhereHeader = (
    filters: IAviaSearchToAnywhereFilters,
): string | null => {
    const filtersText: string[] = [];

    // TODO: Без пересадок убираем пока бэк не начнет возвращать эти данные для всех городов
    // if (filters.withoutTransfers) {
    //     filtersText.push(i18nBlock.transfersFilterTitle());
    // }

    if (filters.withoutVisa) {
        filtersText.push(i18nBlock.visaFilterTitle());
    }

    if (filters.countries.length) {
        filters.countries.forEach(country => {
            const text = countryFilterToText[country];

            if (text) filtersText.push(text);
        });
    }

    if (filters.covid19.length) {
        filters.covid19.forEach(covid =>
            filtersText.push(covid19FilterToText[covid]),
        );
    }

    if (filters.noQuarantine) {
        filtersText.push(i18nBlock.quarantineFilterTitle());
    }

    if (filters.acceptMirBankCard) {
        filtersText.push(i18nBlock.bankCardsFilterMir());
    }

    if (!filtersText.length) return null;

    return filtersText.length === 1
        ? filtersText[0]
        : i18nBlock.allDirections();
};
