import {useEffect} from 'react';
import {batch, useDispatch, useSelector} from 'react-redux';

import {ISettlementGroup} from '../types/ISettlementGroup';

import {inlineSearchRequest} from 'reducers/avia/searchToAnywhere/inlineSearchRequest';

import {
    searchToAnywhereGetInlineSearchDataForCity,
    searchToAnywhereInlineSearchesSelector,
    searchToAnywhereRequestParamsSelector,
} from 'selectors/avia/searchToAnywhere/searchToAnywhereSelectors';

/** Запуск инлайн-поисков */
export const useAviaSearchToAnywhereInlinePriceSearch = (
    settlementGroups: ISettlementGroup[],
): void => {
    const dispatch = useDispatch();
    const requestParams = useSelector(searchToAnywhereRequestParamsSelector);
    const inlineSearches = useSelector(searchToAnywhereInlineSearchesSelector);

    useEffect(() => {
        if (!requestParams) {
            return;
        }

        batch(() => {
            settlementGroups.forEach(({settlements}) =>
                settlements.forEach(settlement => {
                    const inlineSearchData =
                        searchToAnywhereGetInlineSearchDataForCity(
                            inlineSearches,
                            settlement.key,
                        );
                    const priceFromPriceIndexIsExact = Boolean(
                        settlement.price && !settlement.price.expired,
                    );
                    const inlineSearchStarted = Boolean(inlineSearchData);

                    if (!priceFromPriceIndexIsExact && !inlineSearchStarted) {
                        dispatch(
                            inlineSearchRequest(requestParams, settlement.key),
                        );
                    }
                }),
            );
        });
    }, [requestParams, settlementGroups, inlineSearches, dispatch]);
};
