import {useMemo} from 'react';

import {IAnywhereSettlementInfo} from 'types/avia/landing/ISettlementInfo';
import {
    ECountriesFilter,
    ECovid19Filter,
    IAviaSearchToAnywhereFilters,
} from '../types/IAviaSearchToAnywhereFilters';

import {countryRegionMap} from '../utilities/countryRegionMap';

export const useAviaSearchToAnywherePrepareSettlements = (
    filters: IAviaSearchToAnywhereFilters,
    settlements: IAnywhereSettlementInfo[],
): IAnywhereSettlementInfo[] => {
    const filteredSettlements = useMemo(
        () =>
            settlements.filter(settlement => {
                const restrictions = settlement.country_restrictions.metrics;

                // TODO: Без пересадок убираем пока бэк не начнет возвращать эти данные для всех городов
                // const transfersFilter =
                //                 !filters.withoutTransfers ||
                //                 restrictions.flightsAvailabilityV2?.value ===
                //                     EFlightsAvailabilityV2.DIRECT_FLIGHTS;

                const visaFilter =
                    !filters.withoutVisa || !restrictions.visaRequired?.value;

                const coutriesFilter =
                    filters.countries.length === 0 ||
                    filters.countries.some(
                        region => region === ECountriesFilter.ALL,
                    ) ||
                    filters.countries.some(region => {
                        const settlemetnRegion = countryRegionMap.get(
                            settlement.geo_data.countryId,
                        );

                        return settlemetnRegion === region;
                    });

                const covid19Filter =
                    filters.covid19.length === 0 ||
                    filters.covid19.some(filter => {
                        if (filter === ECovid19Filter.PCR_TEST) {
                            return Boolean(
                                restrictions
                                    .pcrExpirationPeriodInHoursOrRequired
                                    ?.value,
                            );
                        }

                        if (filter === ECovid19Filter.SPUTNIK_V) {
                            return Boolean(
                                restrictions.isSputnikApproved?.value,
                            );
                        }

                        if (filter === ECovid19Filter.VACCINE_WHO) {
                            return Boolean(
                                restrictions.approvedVaccines?.value.length,
                            );
                        }

                        return true;
                    });

                const quarantineFilter =
                    !filters.noQuarantine ||
                    !restrictions.quarantineRequired?.value;

                const acceptMirBankCard =
                    !filters.acceptMirBankCard ||
                    Boolean(restrictions.bankCardPayments?.value.mir);

                return (
                    // transfersFilter &&
                    visaFilter &&
                    coutriesFilter &&
                    quarantineFilter &&
                    covid19Filter &&
                    quarantineFilter &&
                    acceptMirBankCard
                );
            }),
        [filters, settlements],
    );

    return filteredSettlements;
};
