export enum ECountriesFilter {
    /** Все страны */
    ALL = 'all',
    /** По России */
    RUSSIA = 'russia',
    /** Страны СНГ */
    CIS = 'cis',
    /** Европа */
    EUROPE = 'europe',
    /** Азия */
    ASIA = 'asia',
    /** Америка */
    AMERICA = 'america',
    /** Африка */
    AFRICA = 'africa',
    /** Остальные */
    OTHER = 'other',
}

export const allCoutriesFilter = [
    ECountriesFilter.ALL,
    ECountriesFilter.RUSSIA,
    ECountriesFilter.CIS,
    ECountriesFilter.EUROPE,
    ECountriesFilter.ASIA,
    ECountriesFilter.AMERICA,
    ECountriesFilter.AFRICA,
] as const;

export enum ECovid19Filter {
    PCR_TEST,
    SPUTNIK_V,
    VACCINE_WHO,
}

export interface IAviaSearchToAnywhereFilters {
    // TODO: Без пересадок убираем пока бэк не начнет возвращать эти данные для всех городов
    /** Без пересадок */
    // withoutTransfers: boolean;
    /** Без визы */
    withoutVisa: boolean;
    /** Страны */
    countries: ECountriesFilter[];
    /** Covid19 */
    covid19: ECovid19Filter[];
    /** Нет карантин */
    noQuarantine: boolean;
    /** Принимают карты Мир */
    acceptMirBankCard: boolean;
}

export interface IAviaSearchToAnywhereFiltersHanlders {
    // TODO: Без пересадок убираем пока бэк не начнет возвращать эти данные для всех городов
    // onTransfersFilterChange: () => void;
    onVisaFilterChange: () => void;
    onQuarantineFilterChange: () => void;
    onAcceptMirBankCardChange: () => void;

    onCountriesFilterReset: () => void;
    onCovid19FilterReset: () => void;

    onCountriesFilterChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    onCovid19FilterChange: (e: React.ChangeEvent<HTMLInputElement>) => void;

    onReset: () => void;
}

export function getDefaultValues(): IAviaSearchToAnywhereFilters {
    return {
        // withoutTransfers: false,
        withoutVisa: false,
        countries: [],
        covid19: [],
        noQuarantine: false,
        acceptMirBankCard: false,
    };
}
