import {
    ECountriesFilter,
    ECovid19Filter,
} from '../types/IAviaSearchToAnywhereFilters';

import * as i18nBlock from 'i18n/avia-SearchToAnywhere';

export const countryFilterToText: Record<ECountriesFilter, string | undefined> =
    {
        [ECountriesFilter.ALL]: undefined,
        [ECountriesFilter.OTHER]: undefined,
        [ECountriesFilter.RUSSIA]: i18nBlock.countriesFilterRussia(),
        [ECountriesFilter.CIS]: i18nBlock.countriesFilterCis(),
        [ECountriesFilter.EUROPE]: i18nBlock.countriesFilterEurope(),
        [ECountriesFilter.ASIA]: i18nBlock.countriesFilterAsia(),
        [ECountriesFilter.AMERICA]: i18nBlock.countriesFilterAmerica(),
        [ECountriesFilter.AFRICA]: i18nBlock.countriesFilterAfrica(),
    };

export const covid19FilterToText: Record<ECovid19Filter, string> = {
    [ECovid19Filter.PCR_TEST]: i18nBlock.covid19FilterPcrTest(),
    [ECovid19Filter.SPUTNIK_V]: i18nBlock.covid19FilterSputnikV(),
    [ECovid19Filter.VACCINE_WHO]: i18nBlock.covid19FilterVaccineWho(),
};
