import {ServerDataFetcherBag} from 'server/redux/types';
import {IAviaSearchToAnywherePageParams} from 'projects/avia/pages/AviaSearchToAnywhere/types/IAviaSearchToAnywherePageParams';

import {requestSearchToAnywhereThunkAction} from 'reducers/avia/searchToAnywhere/requestSearchToAnywhereThunkAction';

import {TServerFetchData} from 'contexts/ServerFetchDataContext';

export function prefetchData(
    params: IAviaSearchToAnywherePageParams,
): TServerFetchData {
    return async (bag: ServerDataFetcherBag): Promise<void> => {
        const {req, res, dispatch} = bag;

        await dispatch(
            requestSearchToAnywhereThunkAction({
                req,
                res,
                ...params,
            }),
        );
    };
}
