import {ServerDataFetcherBag} from 'server/redux/types';
import {IAviaSearchToCountryPageParams} from 'projects/avia/pages/AviaSearchToCountry/types/IAviaSearchToCountryPageParams';

import requestSearchToCountryThunkAction from 'reducers/avia/searchToCountry/requestSearchToCountryThunkAction';

import {TServerFetchData} from 'contexts/ServerFetchDataContext';

export function prefetchData(
    params: IAviaSearchToCountryPageParams,
): TServerFetchData {
    return async (bag: ServerDataFetcherBag): Promise<void> => {
        const {req, res, dispatch} = bag;

        await dispatch(
            requestSearchToCountryThunkAction({
                req,
                res,
                ...params,
            }),
        );
    };
}
