import React from 'react';

import Heading from 'components/Heading/Heading';
import AviaLayout from 'projects/avia/components/AviaLayout';
import TicketCatM from 'icons/illustrations/TicketCat/TicketCatM';

import cx from './styles.scss';

interface IAviaUnsubscribePageProps {
    header: string;
    text: React.ReactNode;
}

export default function AviaUnsubscribePage({
    header,
    text,
}: IAviaUnsubscribePageProps) {
    return (
        <AviaLayout>
            <div className={cx('root')}>
                <TicketCatM className={cx('image')} width={158} height={158} />

                <Heading className={cx('heading')} level={2}>
                    {header}
                </Heading>

                <span className={cx('text')}>{text}</span>
            </div>
        </AviaLayout>
    );
}
