import {compose} from 'redux';
import {connect} from 'react-redux';

import {aviaSubscriptionSelector} from 'selectors/avia/search/subscription';

import UnsubscribePage from 'projects/avia/pages/AviaSubscription/Unsubscribe';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import {cancelAviaSubscription} from 'server/redux/avia/cancelSubscription';

function AviaUnsubscribeAll({
    subscription,
}: ReturnType<typeof aviaSubscriptionSelector>) {
    const {unsubscribedSuccessfully} = subscription;
    const header = unsubscribedSuccessfully
        ? 'Подписка отменена'
        : 'Возникла ошибка';
    const text = unsubscribedSuccessfully
        ? 'Вам больше не будут приходить письма от Яндекс.Авиабилетов'
        : 'Попробуйте повторить операцию позднее';

    return <UnsubscribePage header={header} text={text} />;
}

export default compose(
    serverFetchDataDispatcher([cancelAviaSubscription]),
    connect(aviaSubscriptionSelector),
)(AviaUnsubscribeAll);
