/* eslint-disable camelcase */

import {compose} from 'redux';
import {connect} from 'react-redux';

import {StoreInterface} from 'reducers/storeTypes';

import {aviaSubscriptionSelector} from 'selectors/avia/search/subscription';

import {CHAR_EM_DASH, CHAR_NBSP} from 'utilities/strings/charCodes';

import DateLabel from 'components/DateLabel/DateLabel';

import UnsubscribePage from 'projects/avia/pages/AviaSubscription/Unsubscribe';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import {cancelAviaSubscription} from 'server/redux/avia/cancelSubscription';
import {prefillAviaContextByQKey} from 'server/redux/avia/prefillSearchForm';

const SEPARATOR = `${CHAR_NBSP}${CHAR_EM_DASH}${CHAR_NBSP}`;

const mapStateToProps = (state: StoreInterface) => {
    const {subscription} = aviaSubscriptionSelector(state);
    const {
        avia: {aviaContext},
    } = state;

    return {
        aviaContext,
        subscription,
    };
};

function AviaUnsubscribeAll({
    subscription,
    aviaContext,
}: ReturnType<typeof mapStateToProps>) {
    const {unsubscribedSuccessfully} = subscription;
    const {from, to, when, return_date} = aviaContext;

    // TODO: добавить разбор контекста по queryKey (https://st.yandex-team.ru/RASPTICKETS-16196)
    const fromTitle = (from && from.title) || 'Откуда';
    const toTitle = (to && to.title) || 'Куда';
    const contextData = `${fromTitle}${SEPARATOR}${toTitle}`;

    const header = unsubscribedSuccessfully
        ? 'Подписка отменена'
        : 'Возникла ошибка';
    const text = unsubscribedSuccessfully ? (
        <>
            {`Вам больше не будут приходить уведомления об изменении цены (${contextData}, `}
            <DateLabel
                startDate={when}
                endDate={return_date || when}
                checkSameDate={false}
                shortFormat={false}
            />
            )
        </>
    ) : (
        'Попробуйте повторить операцию позднее'
    );

    return <UnsubscribePage header={header} text={text} />;
}

export default compose(
    serverFetchDataDispatcher([
        cancelAviaSubscription,
        prefillAviaContextByQKey,
    ]),
    connect(mapStateToProps),
)(AviaUnsubscribeAll);
