import {Switch, Route} from 'react-router-dom';

import {URLs} from 'constants/urls';

import ConfirmSubscription from 'projects/avia/pages/AviaSubscription/Confirm';
import UnsubscribeAll from 'projects/avia/pages/AviaSubscription/UnsubscribeAll';
import UnsubscribeByDirection from 'projects/avia/pages/AviaSubscription/UnsubscribeByDirection';

export default function AviaSubscription() {
    return (
        <Switch>
            <Route
                path={URLs.aviaConfirmSubscription}
                component={ConfirmSubscription}
            />
            <Route
                path={URLs.aviaUnsubscribeByDirection}
                component={UnsubscribeByDirection}
            />
            <Route path={URLs.aviaUnsubscribe} component={UnsubscribeAll} />
        </Switch>
    );
}
