import React from 'react';

import {IAviaFlightTickets} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text from 'components/Text/Text';
import Card from 'components/Card/Card';
import TextBlock from 'components/SectionTextBlock/components/TextBlock/TextBlock';
import Box from 'components/Box/Box';
import ButtonLink from 'components/ButtonLink/ButtonLink';

import cx from './Book.scss';

interface IBookProps extends IWithQaAttributes {
    text: IAviaFlightTickets['text'];
    button: IAviaFlightTickets['button'];
}

const Book: React.FC<IBookProps> = props => {
    const {text, button} = props;

    const deviceType = useDeviceType();

    return (
        <Card
            className={cx('root', deviceMods('root', deviceType))}
            shadow="default"
            above={deviceType.isMobile ? 3 : 0}
            {...prepareQaAttributes(props)}
        >
            <Text weight="bold" size="xl" tag="div">
                {text.title}
            </Text>

            <Box
                above={4}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'text',
                })}
            >
                {text.text.map((block, index) => (
                    <TextBlock key={index} block={block} between={0} />
                ))}
            </Box>

            <ButtonLink
                className={cx('button')}
                theme="primary"
                to={button.link}
                size={deviceType.isMobile ? 'l' : 'm'}
                width="max"
                {...prepareQaAttributes({
                    parent: props,
                    current: 'button',
                })}
            >
                {button.text}
            </ButtonLink>
        </Card>
    );
};

export default React.memo(Book);
