import React from 'react';

import {IAviaBreadCrumb} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import CommonBreadcrumbs from 'components/Breadcrumbs/Breadcrumbs';

import cx from './Breadcrumbs.scss';

interface IBreadcrumbsProps {
    items: IAviaBreadCrumb[];
}

const Breadcrumbs: React.FC<IBreadcrumbsProps> = props => {
    const {items} = props;

    return (
        <CommonBreadcrumbs className={cx('root')} hasBorder>
            {items.map(({title, link}, index) => (
                <CommonBreadcrumbs.Item
                    key={title}
                    className={cx('item')}
                    active={!items[index + 1]}
                    to={link}
                >
                    {title}
                </CommonBreadcrumbs.Item>
            ))}
        </CommonBreadcrumbs>
    );
};

export default React.memo(Breadcrumbs);
