import React from 'react';
import {useLocation} from 'react-router-dom';

import {IAviaFlightDate} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {IWithClassName} from 'types/withClassName';

import {formatDate} from 'utilities/dateUtils';
import {ROBOT} from 'utilities/dateUtils/formats';
import getUrlWithUpdatedQueryByLocation from 'utilities/url/getUrlWithUpdatedQueryByLocation';

import Tabs from 'components/Tabs/Tabs';

interface IDatesProps extends IWithClassName {
    items: IAviaFlightDate[];
}

const Dates: React.FC<IDatesProps> = props => {
    const {className, items} = props;

    const location = useLocation();

    return (
        <Tabs
            className={className}
            border
            tabs={items}
            activeTabId={items.find(({selected}) => selected)?.departureDate}
            getTabId={(tab): string => tab.departureDate}
            renderTab={({tab, tabProps}): React.ReactNode => {
                return (
                    <Tabs.Tab
                        key={tab.departureDate}
                        {...tabProps}
                        to={getUrlWithUpdatedQueryByLocation(
                            {
                                when: formatDate(tab.departureDate, ROBOT),
                            },
                            location,
                        )}
                    >
                        {tab.shownDepartureDate}
                    </Tabs.Tab>
                );
            }}
        />
    );
};

export default React.memo(Dates);
