import React from 'react';

import {TLD} from 'constants/tld';

import {IWithClassName} from 'types/withClassName';
import {Platform} from 'types/Platform';

import {directHelper} from 'projects/avia/lib/directHelper';

import {Direct as CommonDirect} from 'components/Direct/Direct';

interface IDirectProps extends IWithClassName {}

const Direct: React.FC<IDirectProps> = props => {
    const {className} = props;

    return (
        <CommonDirect
            className={className}
            blockId={directHelper.getId(TLD.RU, Platform.DESKTOP, 'flight')}
        />
    );
};

export default React.memo(Direct);
