import React from 'react';

import {
    IAviaFlightAircraftType,
    IAviaFlightBaggage,
    IAviaFlightRating,
    IAviaFlightTariffs,
} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {ISectionTextBlock} from 'types/common/seoPages/ITextBlocks';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Card from 'components/Card/Card';
import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import SectionTextBlock from 'components/SectionTextBlock/SectionTextBlock';
import Separator from 'components/Separator/Separator';
import Tariffs from 'projects/avia/pages/FlightPage/components/MainInfo/components/Tariffs/Tariffs';
import Baggage from 'projects/avia/pages/FlightPage/components/MainInfo/components/Baggage/Baggage';
import Stats from 'projects/avia/pages/FlightPage/components/MainInfo/components/Stats/Stats';
import Aircraft from 'projects/avia/pages/FlightPage/components/MainInfo/components/Aircraft/Aircraft';

import cx from './MainInfo.scss';

interface IMainInfoProps extends IWithClassName {
    tariffs: IAviaFlightTariffs | undefined;
    baggage: IAviaFlightBaggage | undefined;
    stats: IAviaFlightRating | undefined;
    aircraftType: IAviaFlightAircraftType | undefined;
    description: ISectionTextBlock | undefined;
}

const MainInfo: React.FC<IMainInfoProps> = props => {
    const {className, tariffs, baggage, stats, aircraftType, description} =
        props;

    const deviceType = useDeviceType();

    return (
        <Card
            className={cx('root', deviceMods('root', deviceType), className)}
            shadow="default"
            between={deviceType.isMobile ? 5 : 7}
        >
            {tariffs && <Tariffs title={tariffs.title} items={tariffs.items} />}

            <Flex flexDirection={deviceType.isMobile ? 'column' : 'row'}>
                {(baggage || description) && (
                    <Box className={cx('column')} between={5}>
                        {baggage && (
                            <Baggage
                                title={baggage.title}
                                description={baggage.description}
                                restrictions={baggage.baggageRestrictions}
                            />
                        )}

                        {description && (
                            <SectionTextBlock
                                block={description}
                                deviceType={deviceType}
                                betweenItems={4}
                            />
                        )}
                    </Box>
                )}

                {(stats || aircraftType) && (
                    <Box className={cx('column')}>
                        {stats && (
                            <>
                                {deviceType.isMobile && (
                                    <Separator className={cx('separator')} />
                                )}

                                <Stats
                                    className={cx('stats')}
                                    title={stats.title}
                                    items={stats.items}
                                />
                            </>
                        )}

                        {aircraftType && (
                            <>
                                {deviceType.isMobile && (
                                    <Separator className={cx('separator')} />
                                )}

                                <Aircraft
                                    className={cx('aircraft')}
                                    title={aircraftType.title}
                                    type={aircraftType.aircraftType}
                                />
                            </>
                        )}
                    </Box>
                )}
            </Flex>
        </Card>
    );
};

export default React.memo(MainInfo);
