import React from 'react';

import {IWithClassName} from 'types/withClassName';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';

interface IAircraftProps extends IWithClassName {
    title: string;
    type: string;
}

const Aircraft: React.FC<IAircraftProps> = props => {
    const {className, title, type} = props;

    return (
        <div className={className}>
            <Heading level="2">{title}</Heading>

            <Box textSize="m" above={4}>
                {type}
            </Box>
        </div>
    );
};

export default React.memo(Aircraft);
