import React from 'react';

import {IAviaFlightBaggageRestrictions} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import Text from 'components/Text/Text';
import Box from 'components/Box/Box';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import BaggageIcon from 'icons/16/Baggage';
import HandLuggageIcon from 'icons/16/HandLuggage';
import Heading from 'components/Heading/Heading';

interface IBaggageProps {
    title: string;
    description: string;
    restrictions: IAviaFlightBaggageRestrictions | undefined;
}

const Baggage: React.FC<IBaggageProps> = props => {
    const {title, description, restrictions} = props;

    return (
        <div>
            <Heading level="2">{title}</Heading>

            <Box above={4} textSize="m">
                {description}
            </Box>

            {restrictions && (
                <Box above={3}>
                    <Text weight="bold">{restrictions.title}</Text>

                    <Box between={2} above={2}>
                        {restrictions.carryOn && (
                            <TextWithIcon
                                text={restrictions.carryOn.description}
                                iconLeft={HandLuggageIcon}
                            />
                        )}

                        {restrictions.baggage && (
                            <TextWithIcon
                                text={restrictions.baggage.description}
                                iconLeft={BaggageIcon}
                            />
                        )}
                    </Box>
                </Box>
            )}
        </div>
    );
};

export default React.memo(Baggage);
