import React from 'react';

import {IAviaFlightRatingItem} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {IWithClassName} from 'types/withClassName';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';

interface IStatsProps extends IWithClassName {
    title: string;
    items: IAviaFlightRatingItem[];
}

const Stats: React.FC<IStatsProps> = props => {
    const {className, title, items} = props;

    return (
        <div className={className}>
            <Heading level="2">{title}</Heading>

            <Box between={2} above={4} textSize="m">
                {items.map((statItem, index) => (
                    <Flex key={index} justifyContent="space-between">
                        <span>{statItem.text}</span>
                        <span>{statItem.percent}</span>
                    </Flex>
                ))}
            </Box>
        </div>
    );
};

export default React.memo(Stats);
