import React from 'react';

import {
    EAviaColor,
    IAviaFlightTariff,
} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import getTariffIcon from 'projects/avia/pages/FlightPage/components/MainInfo/components/Tariffs/utilities/getTariffIcon';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Card from 'components/Card/Card';
import Text from 'components/Text/Text';
import Box from 'components/Box/Box';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import HorizontalScroller from 'components/HorizontalScroller/HorizontalScroller';
import Flex from 'components/Flex/Flex';
import Carousel from 'components/Carousel/Carousel';
import Heading from 'components/Heading/Heading';

import cx from './Tariffs.scss';

interface ITariffsProps {
    title: string;
    items: IAviaFlightTariff[];
}

const Tariffs: React.FC<ITariffsProps> = props => {
    const {title, items} = props;

    const deviceType = useDeviceType();

    const itemsBlock = items.map((tariff, index) => {
        return (
            <Card
                className={cx('tariff')}
                key={index}
                border="normal"
                x={4}
                y={4}
            >
                <Text size="l" weight="medium">
                    {tariff.title}
                </Text>

                <Box between={2} above={3}>
                    {tariff.items.map(tariffItem => (
                        <TextWithIcon
                            className={cx('tariffItem', {
                                tariffItem_green:
                                    tariffItem.color === EAviaColor.GREEN,
                            })}
                            key={tariffItem.type}
                            text={tariffItem.description}
                            size="s"
                            iconLeft={getTariffIcon(
                                tariffItem.type,
                                tariffItem.color,
                            )}
                        />
                    ))}
                </Box>
            </Card>
        );
    });

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            <Heading level="2">{title}</Heading>

            <Box className={cx('listWrapper')} above={3}>
                {deviceType.isMobile ? (
                    <HorizontalScroller offset={4}>
                        <Flex inline nowrap between={3}>
                            {itemsBlock}
                        </Flex>
                    </HorizontalScroller>
                ) : (
                    <Carousel
                        spaceBetween={3}
                        spaceBefore={8}
                        spaceAfter={8}
                        leftOffset={32}
                        rightOffset={32}
                        gradient
                    >
                        {itemsBlock}
                    </Carousel>
                )}
            </Box>
        </div>
    );
};

export default React.memo(Tariffs);
