import {ComponentType} from 'react';

import {
    EAviaColor,
    EAviaFlightTariffItem,
} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {IIconProps} from 'icons/types/icon';

import BaggageIcon from 'icons/16/Baggage';
import IncludeIcon from 'icons/16/Include';
import ExcludeIcon from 'icons/16/Exclude';
import WarningIcon from 'icons/16/Warning';
import HandLuggageIcon from 'icons/16/HandLuggage';

export default function getTariffIcon(
    type: EAviaFlightTariffItem,
    color: EAviaColor,
): ComponentType<IIconProps> {
    switch (type) {
        case EAviaFlightTariffItem.BAGGAGE: {
            return BaggageIcon;
        }

        case EAviaFlightTariffItem.CARRY_ON: {
            return HandLuggageIcon;
        }

        case EAviaFlightTariffItem.MILES:
        case EAviaFlightTariffItem.CHANGING_CARRIAGE:
        case EAviaFlightTariffItem.REFUNDABLE: {
            if (color === EAviaColor.GREEN) {
                return IncludeIcon;
            }

            return ExcludeIcon;
        }

        case EAviaFlightTariffItem.SEAT_SELECTION_CHECK_IN: {
            return WarningIcon;
        }

        default: {
            throw new Error(`getTariffIcon. Неизвестный тип: ${type}`);
        }
    }
}
