import React from 'react';

import {IAviaFlightSegment} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Segment from 'projects/avia/pages/FlightPage/components/Segments/components/Segment/Segment';

import cx from './Segments.scss';

interface ISegmentsProps extends IWithClassName {
    items: IAviaFlightSegment[];
    activeFromStationCode: string | undefined;
    mapBlock: React.ReactNode;
    disclaimerBlock: React.ReactNode;
}

const Segments: React.FC<ISegmentsProps> = props => {
    const {className, items, activeFromStationCode, mapBlock, disclaimerBlock} =
        props;

    const deviceType = useDeviceType();

    const startDepartureFormattedDate = items[0].departure.formattedDate;

    const onlyOneSegment = items.length === 1;

    return (
        <div
            className={cx(
                'root',
                deviceMods('root', deviceType),
                {
                    root_multipleSegments: !onlyOneSegment,
                    root_onlyOneSegment: onlyOneSegment,
                },
                className,
            )}
        >
            {items.map(
                ({departure, arrival, duration, status, lastUpdate}, index) => (
                    <Segment
                        className={cx('item')}
                        key={departure.stationCode}
                        isOpened={
                            activeFromStationCode
                                ? activeFromStationCode ===
                                  departure.stationCode
                                : index === 0
                        }
                        withHeader={!onlyOneSegment}
                        status={status}
                        departure={departure}
                        arrival={arrival}
                        duration={duration}
                        lastUpdate={lastUpdate}
                        mapBlock={mapBlock}
                        disclaimerBlock={
                            onlyOneSegment ? disclaimerBlock : undefined
                        }
                        startDepartureFormattedDate={
                            startDepartureFormattedDate
                        }
                    />
                ),
            )}

            {deviceType.isMobile && !onlyOneSegment && (
                <div className={cx('item')}>{disclaimerBlock}</div>
            )}
        </div>
    );
};

export default React.memo(Segments);
