import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/aviaFlight';

import Text from 'components/Text/Text';

interface ICheckInDesksProps {
    checkInDesks: string;
}

const CheckInDesks: React.FC<ICheckInDesksProps> = props => {
    const {checkInDesks} = props;

    const deviceType = useDeviceType();

    return (
        <Text size="s" tag="div">
            {`${i18nBlock.checkInDesks()}${deviceType.isMobile ? ': ' : ''}`}

            {deviceType.isDesktop && <br />}

            <Text weight="medium" size={deviceType.isMobile ? 's' : 'l'}>
                {checkInDesks}
            </Text>
        </Text>
    );
};

export default React.memo(CheckInDesks);
