import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/aviaFlight';

import Text from 'components/Text/Text';

interface IGateProps {
    gate: string;
}

const Gate: React.FC<IGateProps> = props => {
    const {gate} = props;

    const deviceType = useDeviceType();

    return (
        <Text size="s">
            {`${i18nBlock.gate()}${deviceType.isMobile ? ': ' : ''}`}

            {deviceType.isDesktop && <br />}

            <Text weight="medium" size={deviceType.isMobile ? 's' : 'l'}>
                {gate}
            </Text>
        </Text>
    );
};

export default React.memo(Gate);
