import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

function getPointTitlePart(
    time: string,
    date: string,
    needToShowDate: boolean,
): string {
    return `${time}${needToShowDate ? `, ${date}` : ''}`;
}

export default function getHeaderTitle(
    departureTime: string,
    departureDate: string,
    needToShowDepartureDate: boolean,
    arrivalTime: string,
    arrivalDate: string,
    needToShowArrivalDate: boolean,
): string {
    return `${getPointTitlePart(
        departureTime,
        departureDate,
        needToShowDepartureDate,
    )} ${CHAR_EM_DASH} ${getPointTitlePart(
        arrivalTime,
        arrivalDate,
        needToShowArrivalDate,
    )}`;
}
