import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Text from 'components/Text/Text';

interface IPointTitleAndSettlementProps extends IWithClassName {
    settlement: string;
    stationTitle: string;
    stationCode: string;
}

const PointSettlementAndStation: React.FC<IPointTitleAndSettlementProps> =
    props => {
        const {className, settlement, stationTitle, stationCode} = props;

        const deviceType = useDeviceType();

        return (
            <div className={className}>
                <Text size={deviceType.isMobile ? 'xl' : 'l'} weight="bold">
                    {settlement}
                </Text>

                <Text size="s" tag="div">
                    {`${stationTitle} ${stationCode}`}
                </Text>
            </div>
        );
    };

export default React.memo(PointSettlementAndStation);
