import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ISegmentPlatformProps} from 'projects/avia/pages/FlightPage/components/Segments/components/Segment/types/ISegmentPlatformProps';

import Flex from 'components/Flex/Flex';
import Card from 'components/Card/Card';
import Box from 'components/Box/Box';

interface ISegmentDesktopProps extends ISegmentPlatformProps, IWithClassName {
    durationBlock: React.ReactNode;
}

const SegmentDesktop: React.FC<ISegmentDesktopProps> = props => {
    const {
        className,
        isOpened,
        headerBlock,
        statusLabelBlock,
        checkInDesksBlock,
        gateBlock,
        baggageCarouselsBlock,
        departureSettlementAndStationBlock,
        departureTitleBlock,
        departureTimeBlock,
        departureScheduleTimeBlock,
        departureTerminalBlock,
        arrivalSettlementAndStationBlock,
        arrivalTitleBlock,
        arrivalTimeBlock,
        arrivalScheduleTimeBlock,
        arrivalTerminalBlock,
        durationBlock,
        timeSeparatorBlock,
        lastUpdateBlock,
    } = props;

    const contentBlock = useMemo(() => {
        if (!isOpened) {
            return null;
        }

        return (
            <Card border="normal" x={4} y={5}>
                {statusLabelBlock}

                {baggageCarouselsBlock && (
                    <Box above={1}>{baggageCarouselsBlock}</Box>
                )}

                <Flex justifyContent="space-between" above={10}>
                    {departureSettlementAndStationBlock}

                    {arrivalSettlementAndStationBlock}
                </Flex>

                <Flex justifyContent="space-between" above={2}>
                    {departureTitleBlock}

                    {arrivalTitleBlock}
                </Flex>

                <Flex alignItems="center">
                    {departureTimeBlock}

                    {timeSeparatorBlock}

                    {arrivalTimeBlock}
                </Flex>

                <Flex justifyContent="space-between">
                    {departureScheduleTimeBlock}

                    {durationBlock}

                    {arrivalScheduleTimeBlock}
                </Flex>

                <Flex justifyContent="space-between" above={2}>
                    <Flex inline between={4}>
                        {departureTerminalBlock}

                        {checkInDesksBlock}

                        {gateBlock}
                    </Flex>

                    {arrivalTerminalBlock}
                </Flex>

                {lastUpdateBlock}
            </Card>
        );
    }, [
        arrivalScheduleTimeBlock,
        arrivalSettlementAndStationBlock,
        arrivalTerminalBlock,
        arrivalTimeBlock,
        arrivalTitleBlock,
        checkInDesksBlock,
        departureScheduleTimeBlock,
        departureSettlementAndStationBlock,
        departureTerminalBlock,
        departureTimeBlock,
        departureTitleBlock,
        durationBlock,
        gateBlock,
        isOpened,
        lastUpdateBlock,
        statusLabelBlock,
        timeSeparatorBlock,
    ]);

    return (
        <Box className={className} between={5}>
            {headerBlock}

            {contentBlock}
        </Box>
    );
};

export default React.memo(SegmentDesktop);
