import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ISegmentPlatformProps} from 'projects/avia/pages/FlightPage/components/Segments/components/Segment/types/ISegmentPlatformProps';

import Flex from 'components/Flex/Flex';
import Box from 'components/Box/Box';
import Card from 'components/Card/Card';

import cx from './SegmentMobile.scss';

interface ISegmentMobileProps extends ISegmentPlatformProps, IWithClassName {
    mapBlock: React.ReactNode;
    disclaimerBlock: React.ReactNode;
}

const SegmentMobile: React.FC<ISegmentMobileProps> = props => {
    const {
        className,
        isOpened,
        headerBlock,
        statusLabelBlock,
        checkInDesksBlock,
        gateBlock,
        baggageCarouselsBlock,
        departureSettlementAndStationBlock,
        departureTitleBlock,
        departureTimeBlock,
        departureScheduleTimeBlock,
        departureTerminalBlock,
        arrivalSettlementAndStationBlock,
        arrivalTitleBlock,
        arrivalTimeBlock,
        arrivalScheduleTimeBlock,
        arrivalTerminalBlock,
        timeSeparatorBlock,
        lastUpdateBlock,
        mapBlock,
        disclaimerBlock,
    } = props;

    const contentBlock = useMemo(() => {
        if (!isOpened) {
            return null;
        }

        return (
            <Card border="normal" above={4} x={4} y={4}>
                {statusLabelBlock}

                <Box above={2}>
                    {checkInDesksBlock}
                    {gateBlock}
                    {baggageCarouselsBlock}
                </Box>

                {departureSettlementAndStationBlock}

                <Flex justifyContent="space-between" above={2}>
                    <Box>
                        {departureTitleBlock}

                        {departureTimeBlock}
                    </Box>

                    {departureTerminalBlock}
                </Flex>

                {departureScheduleTimeBlock}

                {timeSeparatorBlock}

                {arrivalSettlementAndStationBlock}

                <Flex justifyContent="space-between" above={2}>
                    <div>
                        {arrivalTitleBlock}

                        {arrivalTimeBlock}
                    </div>

                    {arrivalTerminalBlock}
                </Flex>

                {arrivalScheduleTimeBlock}

                <Box className={cx('mapWrapper')} above={5}>
                    {mapBlock}
                </Box>

                {lastUpdateBlock}

                {disclaimerBlock}
            </Card>
        );
    }, [
        arrivalScheduleTimeBlock,
        arrivalSettlementAndStationBlock,
        arrivalTerminalBlock,
        arrivalTimeBlock,
        arrivalTitleBlock,
        baggageCarouselsBlock,
        checkInDesksBlock,
        departureScheduleTimeBlock,
        departureSettlementAndStationBlock,
        departureTerminalBlock,
        departureTimeBlock,
        departureTitleBlock,
        disclaimerBlock,
        gateBlock,
        isOpened,
        lastUpdateBlock,
        mapBlock,
        statusLabelBlock,
        timeSeparatorBlock,
    ]);

    return (
        <div className={className}>
            {headerBlock}

            {contentBlock}
        </div>
    );
};

export default React.memo(SegmentMobile);
