import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/aviaFlight';

import Text from 'components/Text/Text';

interface ITerminalProps extends IWithClassName {
    terminal: string | null;
}

const Terminal: React.FC<ITerminalProps> = props => {
    const {className, terminal} = props;

    const deviceType = useDeviceType();

    return (
        <div className={className}>
            <Text tag="div" size="s">
                {i18nBlock.terminal()}
            </Text>

            <Text
                tag="div"
                size={deviceType.isMobile ? 'xxl' : 'l'}
                weight={deviceType.isMobile ? 'bold' : 'medium'}
            >
                {terminal || CHAR_EM_DASH}
            </Text>
        </div>
    );
};

export default React.memo(Terminal);
