import {EAviaColor} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import {ELabelThemeType} from 'components/Label/Label';

export default function getLabelStatusTheme(
    textColor: EAviaColor,
): ELabelThemeType {
    switch (textColor) {
        case EAviaColor.RED: {
            return ELabelThemeType.ATTENTION;
        }

        case EAviaColor.GREEN: {
            return ELabelThemeType.PRIMARY;
        }

        case EAviaColor.BLACK:
        case EAviaColor.GREY:
        case EAviaColor.YELLOW: {
            return ELabelThemeType.NEUTRAL;
        }

        default: {
            throw new Error('Авиа. Неизвестный цвет лейбла для статуса.');
        }
    }
}
