import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';

interface ISeoTextProps extends IWithClassName {
    title: string;
    description: string;
}

const SeoText: React.FC<ISeoTextProps> = props => {
    const {className, title, description} = props;

    const deviceType = useDeviceType();

    return (
        <Box className={className} between={deviceType.isMobile ? 4 : 5}>
            <Heading level="2">{title}</Heading>

            <Text tag="div">{description}</Text>
        </Box>
    );
};

export default React.memo(SeoText);
