import React from 'react';

import {IAviaUsefulLinkItem} from 'server/api/AviaGatewayApi/types/IAviaGetFlightPageApiResponse';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import Heading from 'components/Heading/Heading';

import cx from './UsefulLinks.scss';

interface IUsefulLinksProps {
    title: string;
    items: IAviaUsefulLinkItem[];
}

const UsefulLinks: React.FC<IUsefulLinksProps> = props => {
    const {title, items} = props;

    const deviceType = useDeviceType();

    return (
        <Box above={10} textSize="m">
            <Heading level="2">{title}</Heading>

            <Flex
                flexDirection="column"
                alignItems="flex-start"
                between={2}
                above={deviceType.isMobile ? 4 : 5}
            >
                {items.map(({data: {text, url}}, index) => (
                    <Link key={index} className={cx('link')} url={url}>
                        {text}
                    </Link>
                ))}
            </Flex>
        </Box>
    );
};

export default React.memo(UsefulLinks);
