import {useDispatch, useSelector} from 'react-redux';
import {useEffect} from 'react';

import {TAviaFlightStore} from 'reducers/avia/flight/types';

import requestFlightThunkAction from 'reducers/avia/flight/thunk/requestFlightThunkAction';

import flightSelector from 'selectors/avia/flight/flightSelector';

export default function useRequestFlight({
    iata,
    flightNumber,
    when,
}: {
    iata: string;
    flightNumber: string;
    when: string | undefined;
}): TAviaFlightStore {
    const dispatch = useDispatch();

    useEffect(() => {
        dispatch(
            requestFlightThunkAction({
                iata: encodeURIComponent(iata),
                number: flightNumber,
                departureDate: when,
            }),
        );
    }, [dispatch, iata, flightNumber, when]);

    return useSelector(flightSelector);
}
