import {useDispatch, useSelector} from 'react-redux';
import {useEffect} from 'react';

import {setAviaContext} from 'reducers/avia/context/actions';

import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';

export default function useUpdateContext(when: string | undefined): void {
    const dispatch = useDispatch();
    const context = useSelector(aviaContextSelector);

    useEffect(() => {
        if (when && context.when !== when) {
            dispatch(
                setAviaContext({
                    ...context,
                    when: when || '',
                }),
            );
        }
    }, [context, dispatch, when]);
}
