import {ServerDataFetcherBag} from 'server/redux/types';

import fetchFlight from 'server/redux/avia/fetchFlight';
import prefillFlightSearchFormAndContext from 'server/redux/avia/prefillFlightSearchFormAndContext';

export default async function prefetchData(
    serverFetcherData: ServerDataFetcherBag,
): Promise<void> {
    await fetchFlight(serverFetcherData);
    await prefillFlightSearchFormAndContext(serverFetcherData);
}
