import React, {useEffect} from 'react';
import {useSelector} from 'react-redux';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';

import {reachGoal} from 'utilities/metrika';
import {getSearchFormFromContext} from 'projects/avia/lib/search/getSearchFormFromContext';

import * as i18nBlock from 'i18n/avia-emptySerp';

import AviaLayout from 'projects/avia/components/AviaLayout';
import EmptySerpWithContainer from 'components/EmptySerpWithContainer/EmptySerpWithContainer';

import {serverFetchDataDispatcher} from 'contexts/ServerFetchDataContext';

import prefetchInvalidSearchData from 'server/redux/avia/pages/invalidSearchParams/dataFetcher';

const InvalidSearch: React.FC = () => {
    const context = useSelector(aviaContextSelector);
    const searchForm = getSearchFormFromContext(context);

    useEffect(() => {
        reachGoal(EAviaGoal.SEARCH_PAGE_INVALID_PARAMS, {
            avia: {
                invalidSearchParams: searchForm,
            },
        });
    }, []);

    return (
        <AviaLayout
            searchFormIsStatic
            isFixedNavigation={false}
            validateSearchFormOnMount
            searchFormInitialIsExpanded
        >
            <EmptySerpWithContainer
                title={i18nBlock.searchFormErrorTitle()}
                text={i18nBlock.searchFormErrorText()}
            />
        </AviaLayout>
    );
};

export default serverFetchDataDispatcher([prefetchInvalidSearchData])(
    InvalidSearch,
);
