import {Request} from '@yandex-data-ui/core/lib/types';
import {IGeoLookupResponse} from 'server/api/AviaBackendApi/types/IGeoLookup';

import {aviaProvider} from 'serviceProvider/avia/aviaProvider';

export default async function requestGeoLookup({
    req,
    geoId,
}: {
    req?: Request;
    geoId: number | undefined;
}): Promise<IGeoLookupResponse | null> {
    return aviaProvider.provider(req?.container).getGeoLookup({
        geoId,
    });
}
