import {Request} from '@yandex-data-ui/core/lib/types';
import {IAviaGetSuggestsServiceParams} from 'server/services/AviaService/types/IAviaGetSuggestsService';

import {IPreparedAviaSuggestResponse} from 'server/services/AviaService/utilities/prepareSuggestsResponse';

import {aviaProvider} from 'serviceProvider/avia/aviaProvider';

export default async function requestSearchSuggests({
    req,
    field,
    query,
    otherPoint,
    clientCity,
    showCountries,
    showAnywhere,
}: IAviaGetSuggestsServiceParams & {
    req?: Request;
}): Promise<IPreparedAviaSuggestResponse> {
    return aviaProvider.provider(req?.container).getSuggests({
        field,
        query,
        otherPoint,
        clientCity,
        showCountries,
        showAnywhere,
    });
}
