import {EAgeCategory} from '../pages/AviaBooking/types/AgeCategoryType';
import TAgeCategoryInfo from '../types/TAgeCategoryInfo';

/**
 * Функция возвращает список возрастных групп в которых можно показать интент
 *
 * @param boardingAge - возраст пассажира на момент отправки рейса
 * @param ageCategories - возрастные категории
 */
export default function getAgeGroup(
    boardingAge: number,
    ageCategories: TAgeCategoryInfo,
): EAgeCategory[] {
    return Object.entries(ageCategories).reduce<EAgeCategory[]>(
        (categories, [category, ageLimits]) => {
            const {minAge, maxAge} = ageLimits;

            if (boardingAge >= minAge && boardingAge < maxAge) {
                categories.push(category as EAgeCategory);
            }

            return categories;
        },
        [],
    );
}
