/* eslint-disable camelcase */
import omitBy from 'lodash/omitBy';

import {EChildrenMaxAges} from '../constants/childrenAges';

type TChildrenSeatsInfo = {
    infant_seats?: number;
    children_seats?: number;
};

/**
 * Функция возвращает количество детских мест на основании переданных возрастов
 *
 * @param childrenAges - массив возрастов, дети
 */
export default function getChildrenSeasByAges(
    childrenAges: number[],
): TChildrenSeatsInfo {
    let childrenCount = 0;
    let infantCount = 0;

    childrenAges.forEach(age => {
        if (age <= EChildrenMaxAges.INFANT) {
            infantCount++;
        } else if (age <= EChildrenMaxAges.CHILDREN) {
            childrenCount++;
        }
    });

    return omitBy(
        {
            infant_seats: infantCount,
            children_seats: childrenCount,
        },
        age => age === 0,
    );
}
