import {URLs} from 'constants/urls';

import {EYtpReferer} from 'types/common/IAttribution';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';

import {internalUrl} from 'utilities/url';

export interface IGetCrossSaleHotelsSearchUrlParams {
    ytpReferer: EYtpReferer;
    geoId?: number;
    offerSearchParams?: Partial<IRequiredOfferParams>;
}

export function getCrossSaleHotelsSearchUrl({
    ytpReferer,
    geoId,
    offerSearchParams,
}: IGetCrossSaleHotelsSearchUrlParams): string {
    return internalUrl(URLs.hotelsSearch, {
        geoId,
        ...offerSearchParams,
        childrenAges: offerSearchParams?.childrenAges
            ? offerSearchParams.childrenAges.join(',')
            : undefined,
        ytp_referer: ytpReferer,
    });
}
