import {parse} from 'query-string';

import {IUrlQuery} from 'utilities/url/types';

import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {filterValuesToHash} from 'projects/avia/lib/search/filters/converters';
import {getAppliedAviaFilters} from 'projects/avia/lib/search/filters/getAppliedFilters';

/**
 * Возвращает объект с фильтрами поиска для последующей его отправки в
 * параметр fragment getSearchResultsUrl. Он же fragment в internalUrl.
 * @param filters
 */
export default function getFiltersForUrl(
    filters: Partial<IAviaSearchResultsFilters>,
): IUrlQuery {
    return parse(filterValuesToHash(getAppliedAviaFilters(filters)));
}
