import {Moment} from 'moment';

import {DATE, HUMAN} from 'utilities/dateUtils/formats';

export default function getFormattedDatesForPeriod(
    checkinDate: Moment,
    checkoutDate: Moment,
): string[] {
    const checkinAndCheckoutInSameMonths = checkinDate.isSame(
        checkoutDate,
        'month',
    );

    return [
        checkinAndCheckoutInSameMonths
            ? checkinDate.format(DATE)
            : checkinDate.format(HUMAN),
        checkoutDate.format(HUMAN),
    ];
}
