import {EAviaInitSearchError} from 'types/avia/search/EAviaInitSearchError';
import {isUnknownObject} from 'types/utilities';

function isSamePointsError(errorData: unknown): boolean {
    if (!isUnknownObject(errorData) || !isUnknownObject(errorData?.data)) {
        return false;
    }

    return 'same_city' in errorData.data;
}

export function getInitSearchError(errorData: unknown): EAviaInitSearchError {
    if (isSamePointsError(errorData)) {
        return EAviaInitSearchError.SAME_POINTS;
    }

    return EAviaInitSearchError.UNKNOWN;
}
