import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import {TGoalRefundValue} from 'utilities/metrika/types/params/avia';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {reachGoal} from 'utilities/metrika';

export type TTariffGoalContext = 'search' | 'variant';

export function reachChooseTariff(
    variant: IResultAviaVariant,
    context: TTariffGoalContext,
): void {
    let refund: TGoalRefundValue;

    if (variant.price.hasFreeRefund) {
        refund = 'free';
    } else if (variant.price.hasChargedRefund) {
        refund = 'charged';
    } else if (variant.price.hasNoRefund) {
        refund = 'no';
    } else {
        refund = 'unknown';
    }

    const goal =
        context === 'variant'
            ? EAviaGoal.VARIANT_TARIFF_CHOOSE
            : EAviaGoal.SEARCH_TARIFF_CHOOSE;

    reachGoal(goal, {
        avia: {
            baggage: variant.hasBaggage ? 'yes' : 'no',
            refund,
        },
    });
}

export function reachClickTariff(
    variants: IResultAviaVariant[],
    context: TTariffGoalContext,
): void {
    const goal =
        context === 'variant'
            ? EAviaGoal.VARIANT_TARIFF_CLICK
            : EAviaGoal.SEARCH_TARIFF_CLICK;

    reachGoal(goal, {
        avia: {
            count: variants.length,
        },
    });
}
